<?php
/*
Plugin Name: Move Body Meta Tags Into Head
Plugin URI: https://www.seocontentmachine.com
Description: Extract meta tags found inside the body and move them into head.
Version: 1.0
Author: seocontentmachine.com
Author URI: https://www.seocontentmachine.com
*/
if ( ! defined( 'ABSPATH' ) ) exit;

// Start output buffering early for front-end requests.
add_action( 'template_redirect', 'hbmt_start_buffer', 0 );
function hbmt_start_buffer() {
    if ( is_admin() || wp_doing_ajax() || ( function_exists('is_rest') && is_rest() ) || is_feed() ) {
        return;
    }

    ob_start( 'hbmt_filter_output' );
}

function hbmt_filter_output( $html ) {
    if ( empty( $html ) ) return $html;
    if ( stripos( $html, '<meta' ) === false ) return $html;

    libxml_use_internal_errors( true );

    $doc = new DOMDocument();

    // Detect encoding and safely load HTML
    $encoding = mb_detect_encoding( $html, mb_detect_order(), true );
    $html_for_load = $encoding
        ? mb_convert_encoding( $html, 'HTML-ENTITIES', $encoding )
        : $html;

    $flags = 0;
    if ( defined('LIBXML_HTML_NOIMPLIED') ) $flags |= LIBXML_HTML_NOIMPLIED;
    if ( defined('LIBXML_HTML_NODEFDTD') ) $flags |= LIBXML_HTML_NODEFDTD;

    if ( ! $doc->loadHTML( $html_for_load, $flags ) ) {
        libxml_clear_errors();
        return $html;
    }

    // Find <head> and <body>
    $head = $doc->getElementsByTagName('head')->item(0);
    $body = $doc->getElementsByTagName('body')->item(0);

    if ( ! $head || ! $body ) {
        libxml_clear_errors();
        return $html;
    }

    // Collect meta tags *inside* body (clone first because NodeList is live)
    $metas = $body->getElementsByTagName('meta');
    $to_move = [];

    for ( $i = 0; $i < $metas->length; $i++ ) {
        $to_move[] = $metas->item( $i );
    }

    if ( empty( $to_move ) ) {
        libxml_clear_errors();
        return $html;
    }

    // Move them: clone → append to head → remove original
    foreach ( $to_move as $meta ) {
        $head->appendChild( $meta->cloneNode( true ) );
        $meta->parentNode->removeChild( $meta );
    }

    $new_html = $doc->saveHTML();

    libxml_clear_errors();
    return $new_html;
}
